# Java 11 HTTP 服务器项目

这是一个使用Java 11编写的简单HTTP服务器示例，展示了基本的Java网络编程和HTTP服务实现。

## 项目结构

```
java11-template/
├── src/
│   └── main/
│       └── java/
│           └── com/
│               └── example/
│                   └── HelloWorld.java    # 主程序文件
├── Dockerfile                             # Docker容器化配置
├── docker-entrypoint.sh                  # Docker启动脚本
├── Makefile                              # 编译和运行脚本
└── README.md                             # 项目说明文档
```

## 功能特性

- ✅ 基于Java 11的HTTP服务器
- ✅ 使用内置的com.sun.net.httpserver.HttpServer
- ✅ 支持环境变量配置端口
- ✅ 返回"Hello, World!"响应
- ✅ Makefile自动化编译、运行和管理
- ✅ 支持后台运行和进程管理
- ✅ Docker容器化支持

## 环境要求

- Java 11 或更高版本
- Make工具（可选，用于自动化构建）
- Docker（可选，用于容器化运行）

## 快速开始

### 方法一：直接运行

```bash
# 编译程序
javac -d build/classes -source 11 -target 11 src/main/java/com/example/HelloWorld.java

# 运行HTTP服务器
APP_PORT_1=8080 java -cp build/classes com.example.HelloWorld
```

### 方法二：使用Makefile

```bash
# 安装依赖并编译
make install

# 启动HTTP服务器（后台运行）
make run

# 停止服务器
make stop
```

### 方法三：使用Docker

```bash
# 构建Docker镜像
docker build -t java11-hello-world .

# 运行容器
docker run -p 8080:8080 java11-hello-world

# 运行容器并指定端口
docker run -p 9090:8080 -e APP_PORT_1=8080 java11-hello-world
```

## 服务器使用示例

### 启动服务器
```bash
make run
# 输出：
# ✅ Java HTTP 服务器已启动，PID: 12345
# 服务器运行在: http://localhost:8080/
```

### 访问服务器
```bash
curl http://localhost:8080/
# 输出：Hello, World!
```

```bash
make stop
# 输出：
# ✅ 所有相关Java进程已被强制停止
# ✅ 停止操作完成
```

## 代码说明

### HelloWorld.java

HTTP服务器类包含以下功能：

- **main方法**: 程序入口点，启动HTTP服务器
- **端口配置**: 从环境变量APP_PORT_1读取端口，默认8080
- **HTTP处理器**: 实现MyHandler类处理HTTP请求
- **服务器启动**: 使用com.sun.net.httpserver.HttpServer创建HTTP服务

### Makefile

提供了以下核心命令：

- `install`: 检查Java版本并编译源代码
- `run`: 启动HTTP服务器（后台运行）
- `stop`: 停止HTTP服务器（强制停止所有相关进程）

### Dockerfile

- 基于OpenJDK 11镜像
- 自动编译和运行HTTP服务器
- 支持端口配置（APP_PORT_1环境变量）
- 暴露8080端口

## 环境变量

- `APP_PORT_1`: HTTP服务器端口号（默认: 8080）

## 扩展建议

1. **添加更多路由**: 可以添加不同的URL路径处理
2. **静态文件服务**: 添加静态文件（HTML、CSS、JS）服务功能
3. **API接口**: 添加RESTful API接口
4. **日志记录**: 使用Log4j或SLF4J进行日志记录
5. **配置文件**: 添加properties或YAML配置文件支持
6. **Maven/Gradle**: 使用构建工具管理依赖
7. **健康检查**: 添加健康检查端点
8. **HTTPS支持**: 添加SSL/TLS支持

## 许可证

此项目仅用于学习和演示目的。
