#!/bin/bash

# Java 8 HTTP 服务器容器启动脚本

set -e

echo "=== Java 8 HTTP 服务器容器启动 ==="
echo "Java版本: $(java -version 2>&1 | head -n 1)"
echo "工作目录: $(pwd)"
echo "端口: ${APP_PORT_1:-8080}"
echo ""

# 检查Java是否可用
if ! command -v java &> /dev/null; then
    echo "错误: Java未安装或不在PATH中"
    exit 1
fi

# 检查编译后的类文件是否存在
if [ ! -d "build/classes" ]; then
    echo "编译Java源代码..."
    make install
fi

# 运行HTTP服务器
echo "启动HTTP服务器..."
echo "服务器将在端口 ${APP_PORT_1:-8080} 上运行"
echo "=========================================="
exec java -cp build/classes com.example.HelloWorld
