package main

import (
	"fmt"
	"net/http"
	"os"
)

/**
 * HTTP处理器函数
 * @param w HTTP响应写入器
 * @param r HTTP请求对象
 */
func handler(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello, World!")
}

/**
 * 主函数
 * 从环境变量APP_PORT_1获取端口号，默认使用8000
 */
func main() {
	// 从环境变量获取端口号，默认为8000
	port := os.Getenv("APP_PORT_1")
	if port == "" {
		port = "8000"
	}

	http.HandleFunc("/", handler)
	fmt.Printf("Starting server on 0.0.0.0:%s\n", port)
	http.ListenAndServe(":"+port, nil)
}
