# Go 1.22.5 HTTP 服务器模板

一个基于 Go 1.22.5 的简单 HTTP 服务器应用模板，支持环境变量配置和 Docker 容器化部署。

## 🚀 项目特性

- **Go 1.22.5**: 使用最新的 Go 语言版本
- **HTTP 服务器**: 提供简单的 HTTP 服务
- **环境变量配置**: 支持通过环境变量配置端口
- **Docker 支持**: 完整的容器化部署方案
- **Makefile 构建**: 便捷的构建和运行命令
- **生产就绪**: 支持开发和生产环境

## 📁 项目结构

```
golang1.22.5-template/
├── main.go                    # 主程序文件
├── Dockerfile                 # Docker 镜像构建文件
├── docker-entrypoint.sh       # Docker 启动脚本
├── Makefile                   # 构建脚本
├── .eazy                      # 应用配置文件
├── .resource/
│   └── resource_dev.json      # 开发环境资源配置
├── .vscode/                   # VS Code 配置
└── README.md                  # 项目说明文档
```

## 🛠️ 环境要求

- Go 1.22.5 或更高版本
- Docker (可选，用于容器化部署)
- Make (可选，用于使用 Makefile 命令)

## 📦 快速开始

### 1. 克隆项目

```bash
git clone <repository-url>
cd golang1.22.5-template
```

### 2. 使用 Makefile 运行

```bash
# 安装依赖并编译
make install

# 启动服务器（后台运行）
make run

# 停止服务器
make stop
```

### 3. 直接使用 Go 命令

```bash
# 开发模式运行
go run main.go

# 编译并运行
go build -o hello_world main.go
./hello_world
```

## ⚙️ 配置说明

### 环境变量

| 变量名 | 默认值 | 说明 |
|--------|--------|------|
| `APP_PORT_1` | 8000 | HTTP 服务器监听端口 |

### 端口配置

应用支持多个端口配置：
- `APP_PORT_1`: 主端口 (默认: 8000)
- `APP_PORT_2`: 备用端口 (默认: 8001)
- `APP_PORT_3`: 备用端口 (默认: 8002)
- `APP_PORT_4`: 备用端口 (默认: 8003)

## 🐳 Docker 部署

### 构建镜像

```bash
docker build -t golang1.22.5-hello-world .
```

### 运行容器

```bash
# 使用默认端口
docker run -p 8000:8000 golang1.22.5-hello-world

# 使用自定义端口
docker run -p 9000:9000 -e APP_PORT_1=9000 golang1.22.5-hello-world
```

### 开发环境运行

```bash
# 开发模式（直接运行源码）
docker run -p 8000:8000 golang1.22.5-hello-world development
```

## 🔧 开发指南

### 项目结构说明

- `main.go`: 主程序入口，包含 HTTP 服务器逻辑
- `docker-entrypoint.sh`: Docker 启动脚本，支持开发和生产环境
- `Makefile`: 构建和运行脚本
- `.eazy`: 应用配置文件，包含部署信息

### 添加新功能

1. 在 `main.go` 中添加新的路由处理函数
2. 使用 `http.HandleFunc()` 注册路由
3. 重新编译和运行

示例：
```go
func apiHandler(w http.ResponseWriter, r *http.Request) {
    fmt.Fprintf(w, "API Response")
}

func main() {
    http.HandleFunc("/", handler)
    http.HandleFunc("/api", apiHandler)  // 添加新路由
    // ... 其他代码
}
```

### 环境变量使用

在代码中获取环境变量：
```go
port := os.Getenv("APP_PORT_1")
if port == "" {
    port = "8000"  // 默认值
}
```

## 📊 监控和日志

### 查看日志

```bash
# 查看日志
tail -f .logs/app.log
```

### 健康检查

访问以下端点进行健康检查：
- `GET /`: 返回 "Hello, World!"

## 🚀 部署到生产环境

### 使用 Docker

1. 构建生产镜像：
```bash
docker build -t golang1.22.5-hello-world:latest .
```

2. 运行生产容器：
```bash
docker run -d \
  --name golang-app \
  -p 8000:8000 \
  -e APP_PORT_1=8000 \
  golang1.22.5-hello-world:latest
```

### 使用 Makefile

```bash
# 生产环境运行
make run
```

## 🔍 故障排除

### 常见问题

1. **端口被占用**
```bash
# 查看端口占用
lsof -i :8000

# 停止占用端口的进程
make stop
```

2. **编译错误**
```bash
# 重新编译
rm -rf build
make install
```

3. **Docker 构建失败**
```bash
# 检查 Dockerfile 语法
docker build --no-cache -t test .
```

### 调试模式

```bash
# 直接运行 Go 程序
go run main.go
```

## 📝 API 文档

### 端点列表

| 方法 | 路径 | 描述 | 响应 |
|------|------|------|------|
| GET | `/` | 健康检查 | "Hello, World!" |

### 响应格式

所有响应都是纯文本格式。

## 🤝 贡献指南

1. Fork 项目
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 打开 Pull Request

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 📞 支持

如果您遇到任何问题或有任何建议，请：

1. 查看 [故障排除](#故障排除) 部分
2. 创建 [Issue](../../issues)
3. 联系维护者

---

**注意**: 这是一个模板项目，您可以根据实际需求进行修改和扩展。
