#!/bin/bash

# 仓颉 1.0.1 HTTP 服务器容器启动脚本

set -e

echo "=== 仓颉 1.0.1 HTTP 服务器容器启动 ==="
echo "仓颉版本: $(cjc -v 2>&1 | head -n 1)"
echo "工作目录: $(pwd)"
echo "端口: ${APP_PORT_1:-8000}"
echo ""

# 检查仓颉编译器是否可用
if ! command -v cjc &> /dev/null; then
    echo "错误: 仓颉编译器(cjc)未安装或不在PATH中"
    exit 1
fi

# 检查cjpm是否可用
if ! command -v cjpm &> /dev/null; then
    echo "错误: 仓颉包管理器(cjpm)未安装或不在PATH中"
    exit 1
fi

# 检查编译后的文件是否存在
if [ ! -d "target" ]; then
    echo "编译仓颉源代码..."
    cjpm build
fi

# 运行HTTP服务器
echo "启动仓颉 HTTP 服务器..."
echo "服务器将在端口 ${APP_PORT_1:-8000} 上运行"
echo "=========================================="
exec cjpm run
