# 仓颉 1.0.1 HTTP 服务器项目

这是一个使用仓颉 1.0.1 编写的简单 HTTP 服务器示例，展示了基本的仓颉网络编程和 HTTP 服务实现。

## 项目结构

```
cangjie1_0_1_template/
├── src/
│   └── helloworld.cj                       # 主程序文件
├── cjpm.toml                               # 仓颉包管理配置
├── Dockerfile                              # Docker容器化配置
├── docker-entrypoint.sh                   # Docker启动脚本
├── Makefile                               # 编译和运行脚本
└── README.md                              # 项目说明文档
```

## 功能特性

- ✅ 基于仓颉 1.0.1 的 HTTP 服务器
- ✅ 使用仓颉原生 HTTP 库 (stdx.net.http)
- ✅ 支持环境变量配置端口
- ✅ 返回"Hello Cangjie!"响应
- ✅ cjpm 包管理器支持
- ✅ Makefile 自动化编译、运行和管理
- ✅ 支持后台运行和进程管理
- ✅ Docker 容器化支持

## 环境要求

- 仓颉 1.0.1 或更高版本
- cjpm 包管理器
- Make 工具（可选，用于自动化构建）
- Docker（可选，用于容器化运行）

## 快速开始

### 方法一：直接运行

```bash
# 编译仓颉程序
cjpm build

# 运行 HTTP 服务器
APP_PORT_1=8080 cjpm run
```

### 方法二：使用 Makefile

```bash
# 安装依赖并编译
make install

# 启动 HTTP 服务器（后台运行）
make run

# 查看服务器状态
make status

# 停止服务器
make stop

# 强制停止所有相关进程
make kill

# 重启服务器
make restart

# 清理编译文件
make clean

# 查看帮助
make help
```

### 方法三：使用 Docker

```bash
# 构建 Docker 镜像
docker build -t cangjie1.0.1-hello-world .

# 运行容器
docker run -p 8080:8080 cangjie1.0.1-hello-world

# 运行容器并指定端口
docker run -p 9090:8080 -e APP_PORT_1=8080 cangjie1.0.1-hello-world
```

## 服务器使用示例

### 启动服务器
```bash
make run
# 输出：
# ✅ 仓颉 HTTP 服务器已启动，PID: 12345
# 服务器运行在: http://localhost:8080/
```

### 访问服务器
```bash
curl http://localhost:8080/
# 输出：Hello Cangjie!
```

### 查看服务器状态
```bash
make status
# 输出：
# ✅ 服务器正在运行，PID: 12345
# 端口: 8080
# 日志: /path/to/.logs/app.log
```

### 停止服务器
```bash
make stop
# 输出：
# ✅ 进程 12345 已被强制停止
# ✅ 服务器停止操作完成
```

## 代码说明

### helloworld.cj

HTTP 服务器类包含以下功能：

- **main 函数**: 程序入口点，启动 HTTP 服务器
- **端口配置**: 硬编码端口 8081，可通过环境变量 APP_PORT_1 覆盖
- **HTTP 处理器**: 使用 Lambda 表达式处理 HTTP 请求
- **服务器启动**: 使用仓颉原生 HTTP 库创建 HTTP 服务

### Makefile

提供了以下命令：

- `install`: 检查仓颉版本并编译源代码
- `run`: 启动 HTTP 服务器（后台运行）
- `stop`: 停止 HTTP 服务器（直接调用 kill）
- `kill`: 强制停止所有相关仓颉进程
- `restart`: 重启 HTTP 服务器
- `status`: 查看服务器运行状态
- `clean`: 清理编译生成的文件
- `help`: 显示帮助信息

### cjpm.toml

仓颉包管理配置文件，包含：
- 项目名称和版本信息
- 编译目标目录配置
- 依赖管理
- 平台特定配置

### Dockerfile

- 基于仓颉 1.0.1 镜像
- 使用 cjpm 编译和运行 HTTP 服务器
- 支持端口配置（APP_PORT_1 环境变量）
- 暴露 8080 端口

## 环境变量

- `APP_PORT_1`: HTTP 服务器端口号（默认: 8080，代码中硬编码为 8081）

## 仓颉语言特性

本项目展示了仓颉语言的基本特性：

- **包声明**: 使用 `package` 关键字声明包
- **导入语句**: 使用 `import` 关键字导入仓颉标准库
- **函数定义**: 使用 `func` 关键字定义函数
- **Lambda 表达式**: 使用 `{ 参数 => 表达式 }` 语法
- **模式匹配**: 使用 `match` 表达式处理 Option 类型
- **类型推断**: 支持自动类型推断
- **注释**: 支持单行注释 `//` 和多行注释 `/* */`
- **JSDoc 注释**: 支持 `/** */` 格式的文档注释

## 扩展建议

1. **添加更多路由**: 可以添加不同的 URL 路径处理
2. **静态文件服务**: 添加静态文件（HTML、CSS、JS）服务功能
3. **API 接口**: 添加 RESTful API 接口
4. **日志记录**: 使用 Log4j 或 SLF4J 进行日志记录
5. **配置文件**: 添加 properties 或 YAML 配置文件支持
6. **cjpm 依赖管理**: 使用 cjpm 管理项目依赖
7. **健康检查**: 添加健康检查端点
8. **HTTPS 支持**: 添加 SSL/TLS 支持

## 注意事项

- 当前代码中端口硬编码为 8081，环境变量 APP_PORT_1 暂时未生效
- 项目使用 cjpm 作为包管理器，需要确保已安装 cjpm
- 编译后的文件位于 `target` 目录

## 许可证

此项目仅用于学习和演示目的。
