#!/bin/bash

# 设置错误时退出
set -e

# 获取环境变量，默认为production
app_env=${1:-production}

# 定义构建目标
build_target="hello_world"

# 获取端口号，优先使用环境变量
APP_PORT=${APP_PORT_1:-8000}

# 开发环境命令
dev_commands() {
    echo "🚀 运行开发环境命令..."
    echo "📝 使用端口: $APP_PORT"
    echo "🔧 直接运行C程序..."
    APP_PORT_1=$APP_PORT ./$build_target
}

# 生产环境命令
prod_commands() {
    echo "🚀 运行生产环境命令..."
    echo "📝 使用端口: $APP_PORT"
    
    # 检查是否已经编译过
    if [ ! -f "$build_target" ]; then
        echo "🔨 编译C程序..."
        gcc -Wall -Wextra -std=c11 -O2 -o $build_target hello_world.c -pthread
        echo "✅ 编译完成"
    else
        echo "✅ 程序已编译，直接运行"
    fi
    
    # 运行编译后的程序
    echo "🎯 启动HTTP服务器..."
    APP_PORT_1=$APP_PORT ./$build_target
}

# 显示启动信息
echo "=========================================="
echo "🔧 C 12.2.0 HTTP 服务器启动脚本"
echo "=========================================="
echo "环境: $app_env"
echo "端口: $APP_PORT"
echo "时间: $(date)"
echo "=========================================="

# 根据环境变量决定运行模式
if [ "$app_env" = "production" ] || [ "$app_env" = "prod" ]; then
    echo "🏭 检测到生产环境"
    prod_commands
else
    echo "🛠️  检测到开发环境"
    dev_commands
fi
