package com.ruoyi.generator.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ruoyi.generator.domain.getInfoDomain;
import com.ruoyi.generator.service.getInfoService;
import com.sefonsoft.cloud.govern.service.invoke.ServiceSdk;
import com.sefonsoft.cloud.govern.service.invoke.domain.*;
import com.sefonsoft.cloud.govern.service.invoke.utils.Tools;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.*;

@Component("ServiceSdkTest")
public class ServiceSdkTest {

    @Autowired
    getInfoService infoService;

    public static final Logger LOGGER = LoggerFactory.getLogger(ServiceSdkTest.class);


    private static String url ="https://2.19.247.137:18199/data-service/gateway/v2.0/data-service";

    private static String userId="a_sunjiyuan05033655";

    //订阅ID
    private static String subServiceId = "1827987788174319616";

    //应用系统标识
    private static String applicationId = "SYS001";

    //认证token
    private static String accessToken = "1827987788174319617";

    //第一次请求时nextToken位空，下次请求从上次请求的结果中获取nextToken
    private static String nextToken = "";

    @Scheduled(fixedRate = 36000000)
    public void getData() throws Exception {
        DataServiceRequestDTO req = null;
        int size = 1000;

        //当nextToken不为空时查询参数不生效，请求按照第一次的查询条件执行
        if(Tools.isNull(nextToken)){
            List<ServiceRequestFieldDTO> mustFields = new ArrayList<ServiceRequestFieldDTO>();
            mustFields.add(new ServiceRequestFieldDTO("areaId","c..","eq","1591285477854248961"));

            List<ServiceRequestFieldDTO> shouldFields = new ArrayList<ServiceRequestFieldDTO>();
            DateTime date = DateUtil.date();
            DateTime today = DateUtil.beginOfDay(date);
            shouldFields.add(new ServiceRequestFieldDTO("create_date","dt","le",today));
            shouldFields.add(new ServiceRequestFieldDTO("delete_date","dt","le",today));
            shouldFields.add(new ServiceRequestFieldDTO("update_date","dt","le",today));

            DataQuery query = new DataQuery.Builder()
                    .must(mustFields)
                    .should(shouldFields)
                    .build();

            req = new DataServiceRequestDTO.Builder()
                    .size(size)
                    .includeColumns(true)
                    .dataQuery(query)
                    .sort(new SortDTO("id","asc"))
                    .build();
        } else {
            req = new DataServiceRequestDTO.Builder()
                    .size(size)
                    .nextToken(nextToken)  //翻页token，必填参数
                    .includeColumns(false)
                    .build();
        }

        String result = ServiceSdk.invoke(url,req,userId,subServiceId,applicationId,accessToken);
        System.out.println("请求结果" + result);
//        String data = JSONUtil.parseObj(result).get("data").toString();
//        nextToken = JSONUtil.parseObj(data).get("next_token").toString();
        JSONObject JsonData = JSONUtil.parseObj(JSONUtil.parseObj(result).get("data").toString());
        nextToken = JsonData.get("next_token").toString();

        JSONArray jsonArray = JsonData.getJSONArray("list");
        for(int i =0; i<jsonArray.size(); i++){
            JSONObject data = jsonArray.getJSONObject(i);
            getInfoDomain domain = new getInfoDomain();
            domain.setId(data.get("id").toString());
            domain.setCreateDate((Date) data.get("createDate"));
            domain.setCreater(data.get("creater").toString());
            domain.setUpdateDate((Date) data.get("updateDate"));
            domain.setUpdater(data.get("updater").toString());
            domain.setDeleteDate((Date) data.get("deleteDate"));
            domain.setDeleter(data.get("deleter").toString());
            domain.setRemark(data.get("remark").toString());
            domain.setSort((Integer) data.get("sort"));
            domain.setSts(data.get("sts").toString());
            domain.setAreaId(data.get("areaId").toString());
            domain.setCompanyName(data.get("companyName").toString());
            domain.setDescription(data.get("description").toString());
            domain.setGreat((Integer) data.get("great"));
            domain.setInvest((Integer) data.get("invest"));
            domain.setMapAddr(data.get("mapAddr").toString());
            domain.setMode(data.get("mode").toString());
            domain.setProjectAddr(data.get("projectAddr").toString());
            domain.setProjectName(data.get("projectName").toString());
            domain.setRecordCode(data.get("recordCode").toString());
            domain.setRecordDate((Date) data.get("recordDate"));
            domain.setStage(data.get("stage").toString());

            int num = infoService.addInfo(domain);
            LOGGER.info("本次导入{}条数据",num);
        }

    }

}
