/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.utils;

import com.sefonsoft.cloud.govern.service.invoke.constants.SignatureMethod;
import com.sefonsoft.cloud.govern.service.invoke.constants.SignatureVersion;
import com.sefonsoft.cloud.govern.service.invoke.domain.AuthInfo;
import com.sefonsoft.cloud.govern.service.invoke.utils.Tools;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyTools {
    private static final Logger log = LoggerFactory.getLogger(IdentifyTools.class);
    private static final Logger logger = LoggerFactory.getLogger(IdentifyTools.class);

    public static boolean auth(AuthInfo auth, String params, String solt, String signature) {
        try {
            if (Tools.isNull(auth.getSignatureVersion())) {
                return false;
            }
            String signatureMethod = (SignatureVersion.VERSION2.getCode().equals(auth.getSignatureVersion()) ? SignatureMethod.HmacSHA256 : SignatureMethod.HmacSHA1).getCode();
            String signStr = IdentifyTools.sign(params, solt, signatureMethod, auth.getEncoding());
            if (!signature.equals(signStr)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("\u8ba4\u8bc1\u9519\u8bef:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String sign(String data, String key, String signatureMethod, String encoding) throws SignatureException {
        byte[] signature;
        try {
            Mac mac = Mac.getInstance(signatureMethod);
            mac.init(new SecretKeySpec(key.getBytes(), signatureMethod));
            signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(encoding)));
        }
        catch (Exception e) {
            throw new SignatureException("\u751f\u6210\u7b7e\u540d\u5931\u8d25:" + e.getMessage(), e);
        }
        return new String(signature);
    }
}

