/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.domain;

import com.sefonsoft.cloud.govern.service.invoke.domain.ServiceRequestFieldDTO;
import com.sefonsoft.cloud.govern.service.invoke.utils.Tools;
import java.util.ArrayList;
import java.util.List;

public class DataQuery {
    private List<ServiceRequestFieldDTO> must;
    private List<ServiceRequestFieldDTO> should;

    public DataQuery() {
    }

    public DataQuery(List<ServiceRequestFieldDTO> must, List<ServiceRequestFieldDTO> should) {
        this.must = must;
        this.should = should;
    }

    public DataQuery must(ServiceRequestFieldDTO field) {
        if (Tools.isNull(this.must)) {
            this.must = new ArrayList<ServiceRequestFieldDTO>();
        }
        this.must.add(field);
        return this;
    }

    public DataQuery should(ServiceRequestFieldDTO field) {
        if (Tools.isNull(this.should)) {
            this.should = new ArrayList<ServiceRequestFieldDTO>();
        }
        this.should.add(field);
        return this;
    }

    public List<ServiceRequestFieldDTO> getMust() {
        return this.must;
    }

    public List<ServiceRequestFieldDTO> getShould() {
        return this.should;
    }

    public static class Builder {
        private List<ServiceRequestFieldDTO> must;
        private List<ServiceRequestFieldDTO> should;

        public Builder must(ServiceRequestFieldDTO field) {
            if (Tools.isNull(this.must)) {
                this.must = new ArrayList<ServiceRequestFieldDTO>();
            }
            this.must.add(field);
            return this;
        }

        public Builder should(ServiceRequestFieldDTO field) {
            if (Tools.isNull(this.should)) {
                this.should = new ArrayList<ServiceRequestFieldDTO>();
            }
            this.should.add(field);
            return this;
        }

        public Builder must(List<ServiceRequestFieldDTO> fields) {
            if (Tools.isNull(this.must)) {
                this.must = new ArrayList<ServiceRequestFieldDTO>();
            }
            this.must.addAll(fields);
            return this;
        }

        public Builder should(List<ServiceRequestFieldDTO> fields) {
            if (Tools.isNull(this.should)) {
                this.should = new ArrayList<ServiceRequestFieldDTO>();
            }
            this.should.addAll(fields);
            return this;
        }

        public DataQuery build() {
            return new DataQuery(this.must, this.should);
        }
    }
}

