/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConfig.class);
    private static final String ES_CONFIG_FILE = "httpclient.properties";
    private static int connectTimeoutSeconds = 30;
    private static int readTimeoutSeconds = 30;
    private static int writeTimeoutSeconds = 30;
    private static int maxConnections = 10;
    private static int connKeepaliveMinute = 5;

    public static Properties readProperties(String fileName) throws Exception {
        Properties properties = new Properties();
        try {
            InputStream inputStream;
            URL url;
            String path;
            boolean flag = true;
            String configPath = System.getProperty("user.dir") + File.separator + "conf" + File.separator + fileName;
            File file = new File(configPath);
            if (flag && file.exists()) {
                properties.load(new FileInputStream(file));
                flag = false;
            }
            if (flag && (file = new File(path = (url = Thread.currentThread().getContextClassLoader().getResource("")).getPath().replace("classes", "conf") + fileName)).exists()) {
                properties.load(new FileInputStream(file));
                flag = false;
            }
            if (flag && null != (inputStream = HttpConfig.class.getClassLoader().getResourceAsStream(fileName))) {
                properties.load(inputStream);
            }
        }
        catch (Exception e) {
            LOG.error("Read config properties error,file=" + fileName, (Throwable)e);
            throw e;
        }
        return properties;
    }

    public static int connectTimeoutSeconds() {
        return connectTimeoutSeconds;
    }

    public static int readTimeoutSeconds() {
        return readTimeoutSeconds;
    }

    public static int writeTimeoutSeconds() {
        return writeTimeoutSeconds;
    }

    public static int maxConnections() {
        return maxConnections;
    }

    public static int connKeepaliveMinute() {
        return connKeepaliveMinute;
    }

    static {
        try {
            Properties properties = HttpConfig.readProperties(ES_CONFIG_FILE);
            if (null != properties && !properties.isEmpty()) {
                connectTimeoutSeconds = Integer.parseInt(properties.getProperty("connect.timeout.seconds"));
                readTimeoutSeconds = Integer.parseInt(properties.getProperty("read.timeout.seconds"));
                writeTimeoutSeconds = Integer.parseInt(properties.getProperty("write.timeout.seconds"));
                maxConnections = Integer.parseInt(properties.getProperty("max.connections"));
                connKeepaliveMinute = Integer.parseInt(properties.getProperty("connection.keep.alive.minutes"));
            }
            LOG.info("connectTimeoutSeconds:" + connectTimeoutSeconds);
            LOG.info("readTimeoutSeconds:" + readTimeoutSeconds);
            LOG.info("writeTimeoutSeconds:" + writeTimeoutSeconds);
            LOG.info("maxConnections:" + maxConnections);
            LOG.info("connKeepaliveMinute:" + connKeepaliveMinute);
        }
        catch (Exception e) {
            LOG.error("Failed to load properties file conf/httpclient.properties", (Throwable)e);
        }
    }
}

