/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.client;

import com.sefonsoft.cloud.govern.service.invoke.client.HttpConfig;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static HttpClient httpClient = null;
    private OkHttpClient okHttpClient;

    private HttpClient() {
        this.initOkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClient getInstance() {
        if (null != httpClient) return httpClient;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (null != httpClient) return httpClient;
            httpClient = new HttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    public OkHttpClient getClient() {
        return this.okHttpClient;
    }

    private void initOkHttpClient() {
        this.okHttpClient = this.okHttpClient();
    }

    private OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().sslSocketFactory(this.sslSocketFactory(), this.x509TrustManager()).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }).retryOnConnectionFailure(false).connectionPool(this.pool()).connectTimeout((long)HttpConfig.connectTimeoutSeconds(), TimeUnit.SECONDS).readTimeout((long)HttpConfig.readTimeoutSeconds(), TimeUnit.SECONDS).writeTimeout((long)HttpConfig.writeTimeoutSeconds(), TimeUnit.SECONDS).build();
    }

    private X509TrustManager x509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private SSLSocketFactory sslSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.x509TrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            LOG.error("create ssl socket factory failed", (Throwable)e);
            return null;
        }
    }

    private ConnectionPool pool() {
        return new ConnectionPool(HttpConfig.maxConnections(), (long)HttpConfig.connKeepaliveMinute(), TimeUnit.MINUTES);
    }
}

