/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sefonsoft.cloud.govern.service.invoke.client.HttpClient;
import com.sefonsoft.cloud.govern.service.invoke.constants.SignatureMethod;
import com.sefonsoft.cloud.govern.service.invoke.constants.SignatureVersion;
import com.sefonsoft.cloud.govern.service.invoke.domain.APIRequestDTO;
import com.sefonsoft.cloud.govern.service.invoke.domain.AuthInfo;
import com.sefonsoft.cloud.govern.service.invoke.utils.HttpUtils;
import com.sefonsoft.cloud.govern.service.invoke.utils.IdentifyTools;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceSdk {
    private static final Logger logger = LoggerFactory.getLogger(ServiceSdk.class);

    public static String invoke(String url, APIRequestDTO request, String userId, String subServiceId, String applicationId, String accessToken) throws Exception {
        logger.info("start request data");
        AuthInfo auth = new AuthInfo(userId, SignatureVersion.VERSION2.getCode(), "UTF-8");
        String signatureMethod = (SignatureVersion.VERSION2.getCode().equals(auth.getSignatureVersion()) ? SignatureMethod.HmacSHA256 : SignatureMethod.HmacSHA1).getCode();
        String signStr = IdentifyTools.sign(JSONObject.toJSONString((Object)auth), accessToken, signatureMethod, auth.getEncoding());
        auth.setSignature(signStr);
        request.setAuthInfo(auth);
        request.setApplicationId(applicationId);
        request.setSubServiceId(subServiceId);
        Request httpRequest = HttpUtils.createHttpRequest(url, JSON.toJSONString((Object)request));
        Response response = HttpClient.getInstance().getClient().newCall(httpRequest).execute();
        logger.info("request data finished");
        return HttpUtils.readBody(response);
    }
}

