/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Tools {
    public static boolean isNull(Object obj) {
        return obj == null || "null".equals(obj);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotNull(Object obj) {
        return obj != null && !"null".equals(obj) && !"".equals(obj);
    }

    public static Date string2Date(String date) {
        Date returnDate = null;
        SimpleDateFormat dateFormat = date.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            returnDate = dateFormat.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return returnDate;
    }

    public static String readFile(String filePath) throws Exception {
        InputStream in = Tools.getFileInputStream(filePath);
        StringBuilder xmlSb = new StringBuilder();
        byte[] b = new byte[1024];
        try {
            int i;
            while ((i = in.read(b)) != -1) {
                xmlSb.append(new String(b, 0, i, "UTF-8"));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return xmlSb.toString();
    }

    public static InputStream getFileInputStream(String fileName) throws IOException {
        File file = new File(Tools.getlocalPath(fileName));
        if (!file.exists()) {
            throw new FileNotFoundException("can't found file : " + fileName);
        }
        FileInputStream in = new FileInputStream(file);
        return in;
    }

    private static String getlocalPath(String fileName) {
        return Tools.class.getResource(fileName).getFile();
    }
}

