/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.utils;

import com.sefonsoft.cloud.govern.service.invoke.utils.Tools;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static Request createHttpRequest(String url, String jsonContent) {
        Request.Builder builder = new Request.Builder();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)jsonContent);
        return builder.url(url).post(body).build();
    }

    public static String readBody(Response response) {
        String responseBody = "";
        if (Tools.isNull(response)) {
            return responseBody;
        }
        try {
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new RuntimeException(response.body().string());
            }
            catch (Exception ex) {
                logger.error("okhttp response error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }
}

