/*
 * Decompiled with CFR 0.152.
 */
package com.sefonsoft.cloud.govern.service.invoke.domain;

import com.sefonsoft.cloud.govern.service.invoke.domain.APIRequestDTO;
import com.sefonsoft.cloud.govern.service.invoke.domain.DataQuery;
import com.sefonsoft.cloud.govern.service.invoke.domain.ServiceRequestFieldDTO;
import com.sefonsoft.cloud.govern.service.invoke.domain.SortDTO;
import com.sefonsoft.cloud.govern.service.invoke.utils.Tools;
import java.util.ArrayList;
import java.util.List;

public class DataServiceRequestDTO
extends APIRequestDTO {
    private String nextToken = "";
    private int size = 10;
    private boolean includeColumns = false;
    private List<ServiceRequestFieldDTO> queryFields;
    private DataQuery dataQuery;
    private List<SortDTO> sorts;

    public DataServiceRequestDTO() {
    }

    public DataServiceRequestDTO(String nextToken, int size, boolean includeColumns, List<ServiceRequestFieldDTO> queryFields, List<SortDTO> sorts) {
        this.nextToken = nextToken;
        this.size = size;
        this.includeColumns = includeColumns;
        this.queryFields = queryFields;
        this.sorts = sorts;
    }

    public DataServiceRequestDTO(String nextToken, int size, boolean includeColumns, DataQuery dataQuery, List<SortDTO> sorts) {
        this.nextToken = nextToken;
        this.size = size;
        this.includeColumns = includeColumns;
        this.dataQuery = dataQuery;
        this.sorts = sorts;
    }

    public DataServiceRequestDTO(String nextToken, int size, boolean includeColumns, DataQuery dataQuery, List<ServiceRequestFieldDTO> queryFields, List<SortDTO> sorts) {
        this.nextToken = nextToken;
        this.size = size;
        this.includeColumns = includeColumns;
        this.dataQuery = dataQuery;
        this.queryFields = queryFields;
        this.sorts = sorts;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isIncludeColumns() {
        return this.includeColumns;
    }

    public List<ServiceRequestFieldDTO> getQueryFields() {
        return this.queryFields;
    }

    public DataQuery getDataQuery() {
        return this.dataQuery;
    }

    public List<SortDTO> getSorts() {
        return this.sorts;
    }

    public static class Builder {
        private String nextToken = "";
        private int size = 10;
        private boolean includeColumns = false;
        private List<ServiceRequestFieldDTO> queryFields;
        private List<SortDTO> sorts;
        private DataQuery dataQuery;

        public Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder includeColumns(boolean includeColumns) {
            this.includeColumns = includeColumns;
            return this;
        }

        public Builder dataQuery(DataQuery dataQuery) {
            this.dataQuery = dataQuery;
            return this;
        }

        @Deprecated
        public Builder queryFields(List<ServiceRequestFieldDTO> queryFields) {
            this.queryFields = queryFields;
            return this;
        }

        @Deprecated
        public Builder query(ServiceRequestFieldDTO queryField) {
            if (Tools.isNull(this.queryFields)) {
                this.queryFields = new ArrayList<ServiceRequestFieldDTO>();
            }
            this.queryFields.add(queryField);
            return this;
        }

        public Builder sorts(List<SortDTO> sorts) {
            this.sorts = sorts;
            return this;
        }

        public Builder sort(SortDTO sort) {
            if (Tools.isNull(this.sorts)) {
                this.sorts = new ArrayList<SortDTO>();
            }
            this.sorts.add(sort);
            return this;
        }

        public DataServiceRequestDTO build() {
            return new DataServiceRequestDTO(this.nextToken, this.size, this.includeColumns, this.dataQuery, this.queryFields, this.sorts);
        }
    }
}

